/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.renderers.messagebox;

import com.ibm.psw.wcl.components.message.MessageInfo;
import com.ibm.psw.wcl.components.message.WMessageBox;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.form.WButton;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.renderer.output.html.HTMLDocumentFragmentWrapper;
import com.ibm.psw.wcl.core.renderer.output.html.IHTMLDocumentFragmentOutput;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.core.skin.StyleDescriptor;
import com.ibm.psw.wcl.renderers.core.html.HTMLContainerRenderer;
import java.awt.ComponentOrientation;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLBRElement;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLImageElement;
import org.w3c.dom.html.HTMLInputElement;
import org.w3c.dom.html.HTMLParagraphElement;
import org.w3c.dom.html.HTMLScriptElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class CustomMessageBoxRenderer
extends HTMLContainerRenderer {
    private static final String TRACE_MASKD = "XWCLMSGD";
    private static final String TRACE_MASKF = "XWCLMSGF";
    private static final String TRACE_MASKT = "XWCLMSGT";
    static /* synthetic */ Class class$com$ibm$psw$wcl$core$form$WButton;

    public IOutput render(RenderingContext rc, Object renderObject) throws RendererException {
        IOutput out = null;
        try {
            WMessageBox message = (WMessageBox)renderObject;
            if (message.hasMessages()) {
                HTMLDocumentFragmentWrapper doc = rc.getDocumentFactory().createHTMLDocumentFragmentWrapper();
                HTMLElement messageElement = doc.createSPANElement();
                String anchorHash = rc.getParameter("wclAnchorHash");
                if (anchorHash != null) {
                    HTMLAnchorElement anchor = doc.createAElement();
                    anchor.setName(anchorHash);
                    anchor.appendChild(doc.createTextNode(""));
                    messageElement.appendChild(anchor);
                } else {
                    HTMLScriptElement script = doc.createSCRIPTElement();
                    script.setType("text/javascript");
                    StringBuffer scriptText = new StringBuffer();
                    scriptText.append("\nvar href = document.location.href;\n");
                    scriptText.append("var anchorIndex = href.indexOf( \"#\" );\n");
                    scriptText.append("if ( anchorIndex != -1 )\n");
                    scriptText.append("{\n");
                    scriptText.append("    var anchorName = href.substring( anchorIndex + 1 );\n");
                    scriptText.append("    document.write( '<A name=\"' + anchorName + '\"><img src=\"" + this.getImageValue(rc, (WComponent)message, "IMG_BLANK") + "\" width=\"0\" height=\"0\" alt=\"\" style=\"display:block;\"/></A>' );\n");
                    scriptText.append("}\n");
                    script.appendChild(doc.createTextNode(scriptText.toString()));
                    doc.appendToContentFragment((Node)script);
                }
                HTMLInputElement hiddenIds = doc.createINPUTElement();
                hiddenIds.setName(rc.encodeName("wclMessageClosed"));
                hiddenIds.setAttribute("type", "hidden");
                messageElement.appendChild(hiddenIds);
                Vector copyMessages = new Vector();
                Iterator iter = message.getMessages();
                while (iter.hasNext()) {
                    copyMessages.add(iter.next());
                }
                Vector nextMessages = this.getNextMessages(copyMessages);
                while (nextMessages.size() > 0) {
                    if (nextMessages.size() > 0) {
                        int type = ((MessageInfo)nextMessages.elementAt(0)).getMsgType();
                        HTMLBRElement br = doc.createBRElement();
                        messageElement.appendChild(br);
                        HTMLTableElement messageTableElement = doc.createTABLEElement();
                        messageTableElement.setBorder("0");
                        messageTableElement.setCellSpacing("1");
                        messageTableElement.setCellPadding("0");
                        messageTableElement.setAlign("CENTER");
                        this.renderCssStyles(rc, (WComponent)message, messageTableElement, "mb2");
                        HTMLTableRowElement messageRowElement = doc.createTRElement();
                        messageRowElement.setVAlign("TOP");
                        HTMLTableCellElement messageImageCell = doc.createTDElement();
                        messageImageCell.setVAlign("TOP");
                        messageImageCell.setWidth("50");
                        messageImageCell.setAlign("CENTER");
                        HTMLImageElement image = doc.createIMGElement();
                        ComponentOrientation orientation = this.getComponentOrientation(rc, (WComponent)message);
                        boolean isRTL = orientation != null && orientation.equals(ComponentOrientation.RIGHT_TO_LEFT);
                        ResourceBundle rb = ResourceBundle.getBundle("com.ibm.psw.wcl.nls.WclMessageResources", rc.getLocale());
                        String imgSrc = null;
                        String imgWidth = null;
                        String imgHeight = null;
                        if (type == 1) {
                            if (rb != null) {
                                image.setAlt(rb.getString("ERROR_ALT_TEXT"));
                            }
                            imgSrc = this.getImageValue(rc, (WComponent)message, "IMG_MESSAGE_ERROR");
                            imgWidth = this.getImageWidth(rc, (WComponent)message, "IMG_MESSAGE_ERROR");
                            imgHeight = this.getImageHeight(rc, (WComponent)message, "IMG_MESSAGE_ERROR");
                        } else if (type == 2) {
                            if (rb != null) {
                                image.setAlt(rb.getString("WARNING_ALT_TEXT"));
                            }
                            imgSrc = this.getImageValue(rc, (WComponent)message, "IMG_MESSAGE_WARNING");
                            imgWidth = this.getImageWidth(rc, (WComponent)message, "IMG_MESSAGE_WARNING");
                            imgHeight = this.getImageHeight(rc, (WComponent)message, "IMG_MESSAGE_WARNING");
                        } else if (type == 3) {
                            if (rb != null) {
                                image.setAlt(rb.getString("INFO_ALT_TEXT"));
                            }
                            if (isRTL) {
                                imgSrc = this.getImageValue(rc, (WComponent)message, "IMG_MESSAGE_INFORMATION_RTL");
                                imgWidth = this.getImageWidth(rc, (WComponent)message, "IMG_MESSAGE_INFORMATION_RTL");
                                imgHeight = this.getImageHeight(rc, (WComponent)message, "IMG_MESSAGE_INFORMATION_RTL");
                            }
                            if (imgSrc == null) {
                                imgSrc = this.getImageValue(rc, (WComponent)message, "IMG_MESSAGE_INFORMATION");
                                imgWidth = this.getImageWidth(rc, (WComponent)message, "IMG_MESSAGE_INFORMATION");
                                imgHeight = this.getImageHeight(rc, (WComponent)message, "IMG_MESSAGE_INFORMATION");
                            }
                        } else {
                            if (rb != null) {
                                image.setAlt(rb.getString("UNKNOWN_ALT_TEXT"));
                            }
                            image.setSrc(this.getImageValue(rc, (WComponent)message, "IMG_BLANK"));
                        }
                        image.setSrc(imgSrc);
                        image.setWidth(imgWidth);
                        image.setHeight(imgHeight);
                        messageImageCell.appendChild(image);
                        this.renderDirection(rc, (WComponent)message, messageTableElement);
                        HTMLTableCellElement messageIDCell = doc.createTDElement();
                        messageIDCell.setVAlign("TOP");
                        messageIDCell.setWidth("*");
                        if (isRTL) {
                            this.renderCssStyles(rc, (WComponent)message, messageImageCell, "mb4");
                            messageIDCell.setAlign("RIGHT");
                            messageRowElement.setAlign("RIGHT");
                        } else {
                            this.renderCssStyles(rc, (WComponent)message, messageImageCell, "mb3");
                            messageIDCell.setAlign("LEFT");
                            messageRowElement.setAlign("LEFT");
                        }
                        messageRowElement.appendChild(messageImageCell);
                        boolean hasResponse = false;
                        Properties closedMessages = new Properties();
                        StringBuffer closedIDs = new StringBuffer("");
                        Iterator iter2 = nextMessages.iterator();
                        while (iter2.hasNext()) {
                            AStyleInfo buttonStyle;
                            MessageInfo info = (MessageInfo)iter2.next();
                            hasResponse = info.isResponse();
                            if (closedIDs.toString().equals("")) {
                                closedIDs.append(info.getUniqueID());
                            } else {
                                closedIDs.append("*" + info.getUniqueID());
                            }
                            HTMLParagraphElement p = doc.createPElement();
                            HTMLElement linkSpan = doc.createSPANElement();
                            WHyperlink idLink = (WHyperlink)message.getMessageBoxComponent(info.getMsgID());
                            if (idLink != null) {
                                if (info.getIDLinkScript() != null) {
                                    idLink.setOnClick(info.getIDLinkScript());
                                }
                                ((IHTMLDocumentFragmentOutput)idLink.getOutput(rc)).appendContentFragment((Node)linkSpan);
                                ((IHTMLDocumentFragmentOutput)idLink.getOutput(rc)).appendHeadFragment((Node)doc.getHeadFragment());
                            } else if (info.getMsgID() != null && info.getMsgID().length() > 0) {
                                linkSpan.appendChild(doc.createTextNode(info.getMsgID()));
                            }
                            p.appendChild(linkSpan);
                            this.renderCssStyles(rc, (WComponent)message, linkSpan, "mb5");
                            messageIDCell.appendChild(p);
                            HTMLElement spanText = doc.createSPANElement();
                            this.renderCssStyles(rc, (WComponent)message, spanText, "mb1");
                            spanText.appendChild(doc.createMarkupTextNode(info.getMsgText()));
                            p.appendChild(spanText);
                            AStyleInfo messageStyle = this.getStyleInfo(rc, (WComponent)message);
                            StyleDescriptor msgButtonDescriptor = null;
                            StyleDescriptor msgButtonMouseOverDescriptor = null;
                            if (messageStyle != null) {
                                msgButtonDescriptor = messageStyle.getStyleDescriptor("b1");
                                msgButtonMouseOverDescriptor = messageStyle.getStyleDescriptor("b2");
                            }
                            if ((buttonStyle = rc.getSkin().getStyleInfo(class$com$ibm$psw$wcl$core$form$WButton == null ? CustomMessageBoxRenderer.class$("com.ibm.psw.wcl.core.form.WButton") : class$com$ibm$psw$wcl$core$form$WButton)) != null && msgButtonDescriptor != null && msgButtonMouseOverDescriptor != null) {
                                buttonStyle.addStyleDescriptor(msgButtonDescriptor);
                                buttonStyle.addStyleDescriptor(msgButtonMouseOverDescriptor);
                            }
                            if (info.getButtonNames() == null) continue;
                            for (int i = 0; i < info.getButtonNames().length; ++i) {
                                WButton button = (WButton)message.getMessageBoxComponent(info.getButtonNames()[i]);
                                button.setStyleInfo(buttonStyle);
                                ((IHTMLDocumentFragmentOutput)button.getOutput(rc)).appendContentFragment((Node)p);
                                ((IHTMLDocumentFragmentOutput)button.getOutput(rc)).appendHeadFragment((Node)doc.getHeadFragment());
                                p.appendChild(doc.createMarkupTextNode("&nbsp;"));
                                p.appendChild(doc.createMarkupTextNode("&nbsp;"));
                                p.appendChild(doc.createMarkupTextNode("&nbsp;"));
                            }
                        }
                        HTMLElement span = doc.createSPANElement();
                        if (!hasResponse && message.isCloseLinkVisible()) {
                            String onBlur;
                            String onFocus;
                            this.renderCssStyles(rc, (WComponent)message, span, "mb1");
                            WHyperlink closeLink = (WHyperlink)message.getMessageBoxComponent("closeLink");
                            if (rb != null) {
                                closeLink.setText(rb.getString("CLOSE_TEXT"));
                            }
                            if ((onFocus = CustomMessageBoxRenderer.getFDAOnFocus((RenderingContext)rc, (WComponent)message, (String)"WMessageBoxCloseMsg")) != null) {
                                closeLink.setAttribute("onFocus", onFocus);
                            }
                            if ((onBlur = CustomMessageBoxRenderer.getFDAOnBlur((RenderingContext)rc, (WComponent)message)) != null) {
                                closeLink.setAttribute("onBlur", onBlur);
                            }
                            if (closeLink.getFormName() != null) {
                                String formName = rc.encodeName(closeLink.getFormName());
                                String js = this.getJavaScriptText();
                                if (js != null && js.length() > 0) {
                                    HTMLScriptElement scriptElement = doc.createSCRIPTElement();
                                    scriptElement.setLang("javascript");
                                    scriptElement.setText(js);
                                    doc.appendToHeadFragment((Node)scriptElement);
                                    doc.makeElementReusable((Element)scriptElement, "WMessageBoxScript");
                                }
                                String wclhiddenEnc = rc.encodeName("wh");
                                String wclMessageClosedEnc = rc.encodeName("wclMessageClosed");
                                Properties parms = new Properties();
                                parms.put(wclhiddenEnc, closeLink.getName());
                                parms.put(wclMessageClosedEnc, closedIDs.toString());
                                closeLink.setURL(WHyperlink.findWForm((WComponent)closeLink).getFormActionURL(rc.getTriggerFactory(), parms));
                                closeLink.setOnClick("return msgAct('" + closeLink.getName() + "'" + "," + "'" + closedIDs.toString() + "'" + "," + "'" + formName + "'" + "," + "'" + wclhiddenEnc + "'" + "," + "'" + wclMessageClosedEnc + "'" + ");");
                            } else {
                                closedMessages.put(rc.encodeName("wclMessageClosed"), closedIDs.toString());
                                closeLink.setTriggerParameters(closedMessages);
                            }
                            ((IHTMLDocumentFragmentOutput)closeLink.getOutput(rc)).appendContentFragment((Node)span);
                            ((IHTMLDocumentFragmentOutput)closeLink.getOutput(rc)).appendHeadFragment((Node)doc.getHeadFragment());
                            messageIDCell.appendChild(span);
                        }
                        messageRowElement.appendChild(messageIDCell);
                        messageTableElement.appendChild(messageRowElement);
                        messageElement.appendChild(messageTableElement);
                        messageElement.appendChild(br);
                        messageElement.appendChild(br);
                        nextMessages = this.getNextMessages(copyMessages);
                    }
                    doc.appendToContentFragment((Node)messageElement);
                }
                out = doc.createOutput(rc);
            }
        }
        catch (ClassCastException cce) {
            throw new RendererException("HTMLMessageBoxRenderer: render(): Render object is not a WMessageBox.");
        }
        return out;
    }

    private Vector getNextMessages(Vector messages) {
        Vector<MessageInfo> nextMessages = new Vector<MessageInfo>();
        if (messages.size() > 0) {
            Vector clone = (Vector)messages.clone();
            int type = ((MessageInfo)clone.elementAt(0)).getMsgType();
            Iterator iter = clone.iterator();
            while (iter.hasNext()) {
                MessageInfo info = (MessageInfo)iter.next();
                int msgType = info.getMsgType();
                boolean response = info.isResponse();
                if (response && nextMessages.size() > 0) break;
                if (response && nextMessages.size() == 0) {
                    nextMessages.add(info);
                    messages.remove(info);
                    break;
                }
                if (type != msgType || response) continue;
                nextMessages.add(info);
                messages.remove(info);
            }
        }
        return nextMessages;
    }

    public String getJavaScriptText() {
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

